VERSION 5.00
Begin VB.Form frmFindAHoliday 
   BorderStyle     =   1  'Fixed Single
   Caption         =   "Find The Date of a Holiday"
   ClientHeight    =   5070
   ClientLeft      =   150
   ClientTop       =   720
   ClientWidth     =   7335
   Icon            =   "frmFindAHoliday.frx":0000
   LinkTopic       =   "Form2"
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   5070
   ScaleWidth      =   7335
   StartUpPosition =   3  'Windows Default
   Begin VB.CommandButton cmdRemoveItem 
      Caption         =   "Remove"
      Enabled         =   0   'False
      Height          =   375
      Left            =   4560
      TabIndex        =   10
      Top             =   4560
      Width           =   1215
   End
   Begin VB.TextBox txtLabelTo 
      BackColor       =   &H80000004&
      BorderStyle     =   0  'None
      Height          =   285
      Left            =   480
      Locked          =   -1  'True
      TabIndex        =   20
      TabStop         =   0   'False
      Text            =   "To:"
      Top             =   3360
      Width           =   735
   End
   Begin VB.TextBox txtLabelFrom 
      BackColor       =   &H80000004&
      BorderStyle     =   0  'None
      Height          =   285
      Left            =   480
      Locked          =   -1  'True
      TabIndex        =   19
      TabStop         =   0   'False
      Text            =   "From:"
      Top             =   2880
      Width           =   735
   End
   Begin VB.OptionButton optByHoliday 
      Caption         =   "By Holiday:"
      Height          =   495
      Left            =   480
      TabIndex        =   0
      Top             =   600
      Value           =   -1  'True
      Width           =   2055
   End
   Begin VB.OptionButton optDisplayAllByYear 
      Caption         =   "Display All By Year"
      Height          =   255
      Left            =   480
      TabIndex        =   3
      Top             =   1920
      Width           =   2055
   End
   Begin VB.CommandButton cmdCalendar 
      Caption         =   "Calendar"
      Enabled         =   0   'False
      Height          =   375
      Left            =   3120
      TabIndex        =   9
      Top             =   4560
      Width           =   1335
   End
   Begin VB.ListBox lstListHolidayDates 
      Height          =   3570
      ItemData        =   "frmFindAHoliday.frx":030A
      Left            =   3120
      List            =   "frmFindAHoliday.frx":030C
      TabIndex        =   8
      Top             =   600
      Width           =   3975
   End
   Begin VB.CommandButton cmdClose 
      Cancel          =   -1  'True
      Caption         =   "Close"
      Height          =   375
      Left            =   360
      TabIndex        =   12
      Top             =   4560
      Width           =   1095
   End
   Begin VB.CommandButton cmdSave 
      Caption         =   "Save List..."
      Enabled         =   0   'False
      Height          =   375
      Left            =   2280
      TabIndex        =   13
      Top             =   5520
      Width           =   1215
   End
   Begin VB.CommandButton cmdClear 
      Caption         =   "Clear"
      Enabled         =   0   'False
      Height          =   375
      Left            =   5880
      TabIndex        =   11
      Top             =   4560
      Width           =   1215
   End
   Begin VB.TextBox txtToYear 
      BackColor       =   &H8000000F&
      Enabled         =   0   'False
      Height          =   285
      Left            =   1440
      TabIndex        =   5
      Top             =   3360
      Width           =   1095
   End
   Begin VB.TextBox txtFromYear 
      Height          =   285
      Left            =   1440
      TabIndex        =   2
      Top             =   2880
      Width           =   1095
   End
   Begin VB.ComboBox cboHoliday 
      Height          =   315
      ItemData        =   "frmFindAHoliday.frx":030E
      Left            =   480
      List            =   "frmFindAHoliday.frx":035D
      Sorted          =   -1  'True
      Style           =   2  'Dropdown List
      TabIndex        =   1
      Top             =   1080
      Width           =   2055
   End
   Begin VB.CheckBox chkSelectRangeOfYears 
      Caption         =   "Select Range of Years"
      Height          =   375
      Left            =   480
      TabIndex        =   4
      Top             =   3840
      Width           =   2055
   End
   Begin VB.CommandButton cmdSelect 
      Caption         =   "Display"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   375
      Left            =   1560
      TabIndex        =   7
      Top             =   4560
      Width           =   1095
   End
   Begin VB.Frame fraByHoliday 
      Height          =   1095
      Left            =   240
      TabIndex        =   18
      Top             =   480
      Width           =   2535
   End
   Begin VB.Frame fraSelectYears 
      Caption         =   "Select Year(s)"
      Height          =   1815
      Left            =   240
      TabIndex        =   21
      Top             =   2520
      Width           =   2535
   End
   Begin VB.Frame fraDisplayAllByYear 
      Height          =   615
      Left            =   240
      TabIndex        =   22
      Top             =   1680
      Width           =   2535
   End
   Begin VB.Line Line1 
      X1              =   0
      X2              =   7320
      Y1              =   0
      Y2              =   0
   End
   Begin VB.Label lblNew 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Height          =   255
      Left            =   6480
      TabIndex        =   17
      Top             =   240
      Width           =   495
   End
   Begin VB.Label Label3 
      BackStyle       =   0  'Transparent
      Caption         =   "New:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   5880
      TabIndex        =   16
      Top             =   240
      Width           =   495
   End
   Begin VB.Label lblTotalResultsListed 
      Alignment       =   1  'Right Justify
      BackStyle       =   0  'Transparent
      Height          =   255
      Left            =   5040
      TabIndex        =   15
      Top             =   240
      Width           =   735
   End
   Begin VB.Label Label1 
      BackStyle       =   0  'Transparent
      Caption         =   "Total Results Listed:"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   3120
      TabIndex        =   14
      Top             =   240
      Width           =   1815
   End
   Begin VB.Line Line2 
      X1              =   3120
      X2              =   7080
      Y1              =   4320
      Y2              =   4320
   End
   Begin VB.Label lblSelectAHoliday 
      BackStyle       =   0  'Transparent
      Caption         =   "Select A Holiday"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   240
      TabIndex        =   6
      Top             =   240
      Width           =   1575
   End
   Begin VB.Menu mnuFile 
      Caption         =   "&File"
      Begin VB.Menu mnuSaveList 
         Caption         =   "Save List..."
         Enabled         =   0   'False
         Shortcut        =   ^S
      End
      Begin VB.Menu mnuOpenFile 
         Caption         =   "Open File..."
         Shortcut        =   ^O
      End
      Begin VB.Menu mnuPrintHolidayList 
         Caption         =   "Print Holiday List"
         Enabled         =   0   'False
         Shortcut        =   {F2}
      End
      Begin VB.Menu mnuCloseWindow 
         Caption         =   "Close Window"
         Shortcut        =   ^C
      End
   End
   Begin VB.Menu mnuList 
      Caption         =   "&List"
      Begin VB.Menu mnuAddHolidayDateToList 
         Caption         =   "Add Holiday Date To List"
         Shortcut        =   ^D
      End
      Begin VB.Menu mnuDisplaySelectedOnCalendar 
         Caption         =   "Display Selected On Calendar"
         Enabled         =   0   'False
         Shortcut        =   ^{F3}
      End
      Begin VB.Menu mnuRemoveSelected 
         Caption         =   "Remove Selected"
         Enabled         =   0   'False
         Shortcut        =   ^R
      End
      Begin VB.Menu mnuClearList 
         Caption         =   "Clear List"
         Enabled         =   0   'False
         Shortcut        =   +{DEL}
      End
   End
End
Attribute VB_Name = "frmFindAHoliday"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False

Function Find_Easter(Yearr, Return_Month_Or_Date)
   Let g = (Yearr Mod 19) + 1
   Let c = Int(Yearr / 100) + 1
   Let x = Int((3 * c) / 4) - 12
   Let z = Int((8 * c) / 25) - 5
   Let d = Int((5 * Yearr) / 4) - x - 10
   Let e = ((11 * g) + 20 + z - x) Mod 30
   If (e = 25 And g > 11) Or (e = 24) Then Let e = e + 1
   Let n = 44 - e
   If n < 21 Then n = n + 30
   Let p = n + 7 - ((d + n) Mod 7)
   If p > 31 Then
      Let p = p - 31
      EasterMonth = 4
   Else
      EasterMonth = 3
   End If
   'Print "Month: " & EasterMonth & " " & "Date: " & p
   If Return_Month_Or_Date = "Get Month" Then Return_Value = EasterMonth
   If Return_Month_Or_Date = "Get Date" Then Return_Value = p
   Find_Easter = Return_Value
End Function
Private Sub chkSelectRangeOfYears_Click()
   If chkSelectRangeOfYears.Value = 1 Then
      txtToYear.Enabled = True
      txtToYear.BackColor = &H80000005 'Make the text box appear active(turn the text box to white)
   ElseIf chkSelectRangeOfYears.Value = 0 Then
      txtToYear.Enabled = False
      txtToYear.BackColor = &H8000000F 'make the text box appear "greyed out(turn it to a grey color)"
   End If
End Sub
Private Sub cmdCalendar_Click()
   Display_Holiday_On_Calendar ("cmdCalendar_Click()")
End Sub
Private Sub mnuDisplaySelectedOnCalendar_Click()
   Display_Holiday_On_Calendar ("cmdCalendar_Click()")
End Sub
Sub Display_Holiday_On_Calendar(Calling_Sub)
   SelectedItem = lstListHolidayDates.ListIndex 'Determine which item is selected.
   
   'Parse string for weekday, month, date, and year:
   HolidayString = lstListHolidayDates.List(SelectedItem)
   'Parse out the holiday name:
   If InStr(HolidayString, "Election Day, U.S.") <> 0 Then
      HolidayString = Mid$(HolidayString, 21)
   Else
      BreakPoint = InStr(HolidayString, ",")
      HolidayString = Mid$(HolidayString, BreakPoint + 2)
   End If
   'Parse out the weekday:
   BreakPoint = InStr(HolidayString, ",")
   WeekDayy = Left(HolidayString, BreakPoint - 1)
   HolidayString = Mid$(HolidayString, BreakPoint + 2)
   
   'Parse out the month:
   BreakPoint = InStr(HolidayString, " ")
   Monthh = Left(HolidayString, BreakPoint - 1)
   HolidayString = Mid$(HolidayString, BreakPoint + 1)
   
   'Parse out the Date and Year:
   BreakPoint = InStr(HolidayString, ",")
   Ddate = Left(HolidayString, BreakPoint - 1)
   Yearr = Mid$(HolidayString, BreakPoint + 2)
   
   'Save data to static variables
   atemp = Selected_Holiday_Sent_To_Calendar("Write Month", Monthh)
   atemp = Selected_Holiday_Sent_To_Calendar("Write Date", Ddate)
   atemp = Selected_Holiday_Sent_To_Calendar("Write Year", Yearr)
   'Next Line: Print the selected Holiday to the calendar
   Form1.Calendarr ("frmFindAHoliday.Display_Holiday_On_Calendar")
   'Put the calendar into view
   If Form1.Visible = True Then
      Form1.SetFocus
   ElseIf frmLargeCalendar.Visible = True Then
      frmLargeCalendar.SetFocus
   End If
End Sub
Private Sub cmdClear_Click()
   Clear_lstListHolidayDates 'clears the list box of all results
End Sub

Private Sub mnuClearList_Click()
   Clear_lstListHolidayDates 'clears the list box of all results
End Sub
Private Sub mnuCloseWindow_Click()
   Close_Window
End Sub
Private Sub cmdClose_Click()
   Close_Window
End Sub
Sub Close_Window()
   frmFindAHoliday.Visible = False
   Clear_lstListHolidayDates
End Sub
Sub Clear_lstListHolidayDates() 'This sub clears this list box of its results.
   lstListHolidayDates.Clear
   lblNew.Caption = 0 'Display total new results shown in the results window (lstListHolidayDates)
   lblTotalResultsListed.Caption = lstListHolidayDates.ListCount
   cmdSave.Enabled = False
   mnuSaveList.Enabled = False
   cmdRemoveItem.Enabled = False
   mnuRemoveSelected = False
   cmdCalendar.Enabled = False
   mnuDisplaySelectedOnCalendar.Enabled = False
   cmdClear.Enabled = False
   mnuClearList.Enabled = False
   mnuPrintHolidayList.Enabled = False
End Sub
Private Sub mnuOpenFile_Click()
   frmOpenFile.filFileOpen.Pattern = "*.dte"
   frmOpenFile.lblStoreCallingProcedure.Caption = "frmFindAHoliday"
   frmOpenFile.Show 1
End Sub
Private Sub cmdRemoveItem_Click()
   Remove_A_List_Item
End Sub
Private Sub mnuPrintHolidayList_Click()
   If frmFindAHoliday.lstListHolidayDates.ListCount >= 170 Then _
      Answer = MsgBox("It may take up to two minutes for printing to start. Proceed?", 36, "Print Holiday List") _
   Else Answer = MsgBox("To print the holiday list click 'OK', otherwise click 'Cancel'.", 1, "Print Holiday List")
   If (Answer = 7) Or (Answer = 2) Then Exit Sub
   Printer.CurrentY = 400
   Printer.Print "Total Holidays Listed: " & lblTotalResultsListed.Caption
   Ccount = 0: Current_X = 1000
   For i = 0 To frmFindAHoliday.lstListHolidayDates.ListCount - 1
      Printer.CurrentX = Current_X
      Printer.CurrentY = (Ccount * 200) + 800
      Printer.Print frmFindAHoliday.lstListHolidayDates.List(i)
      Ccount = Ccount + 1
      If Ccount > 70 Then
         Ccount = 0
         If Current_X = 1000 Then
            Current_X = 5500
         ElseIf Current_X = 5500 Then
            Current_X = 1000
            Printer.EndDoc
         End If
      End If
   Next
   Printer.EndDoc
End Sub
Private Sub mnuRemoveSelected_Click()
   Remove_A_List_Item
End Sub
Sub Remove_A_List_Item() 'This sub removes an item from the list of holiday dates (lstListOfHolidays)
   SelectedItem = lstListHolidayDates.ListIndex
   lstListHolidayDates.RemoveItem (SelectedItem)
   lblTotalResultsListed.Caption = lstListHolidayDates.ListCount
   lblNew.Caption = 0
   If lstListHolidayDates.ListCount = 0 Then
      cmdSave.Enabled = False
      mnuSaveList.Enabled = False
      cmdClear.Enabled = False
      mnuClearList.Enabled = False
      mnuPrintHolidayList.Enabled = False
   End If
   cmdCalendar.Enabled = False
   mnuDisplaySelectedOnCalendar.Enabled = False
   cmdRemoveItem.Enabled = False
   mnuRemoveSelected.Enabled = False
End Sub
Private Sub cmdSave_Click()
   Activate_Save_File_Window
End Sub
Private Sub mnuSaveList_Click()
   Activate_Save_File_Window
End Sub
Sub Activate_Save_File_Window()
   frmSaveFile.Show 1
   frmSaveFile.lblStoreCallingProcedure.Caption = "frmFindAHoliday"
   frmSaveFile.txtFileName.Text = "Holidays.dte"
End Sub
Function InterFunction_Counter(Action, Numberr)
   Static Counter 'Get current value by passing "Add", and 0 into the 'Action' and 'Number' parameters, respectively.
   If Action = "Set Equal To" Then
      Counter = Numberr
   ElseIf Action = "Subtract" Then
      Counter = Counter - Numberr
   ElseIf Action = "Add" Then
      Counter = Counter + Numberr
   ElseIf Action = "Subtract" Then
      Counter = Counter - Numberr
   ElseIf Action = "Multiply" Then
      Counter = Counter * Numberr
   ElseIf Action = "Divide" Then
      Counter = Counter / Numberr
   Else
      Counter = Counter
   End If
   InterFunction_Counter = Counter
End Function
Private Sub cmdSelect_Click()
   Display_Holiday ("cmdSelect_Click()")
End Sub
Private Sub mnuAddHolidayDateToList_Click()
   Display_Holiday ("mnuAddHolidayDateToList_Click()")
End Sub
Sub Display_Holiday(Calling_Sub)
   ToYear = txtToYear.Text: FromYear = txtFromYear.Text
   If optByHoliday.Value = True Then
      HolidaySelection = cboHoliday
      Call Display_Holiday_II(HolidaySelection, FromYear, ToYear, "Display_Holiday(Calling_Sub)")
   End If
   If optDisplayAllByYear = True Then
      If (chkSelectRangeOfYears.Value = 0) Then
         ToYear = FromYear
      Else
         If txtToYear = "" Then ToYear = FromYear Else ToYear = txtToYear.Text
      End If
   End If
   
   If optDisplayAllByYear.Value = True Then
      'Error checking:
      'Determine Error, if any:
      MinimumYear = 1582: ErrorFlag = 0
      If FromYear = "" Then
         ErrorFlag = 2
      ElseIf (FromYear > 100100) Or (ToYear > 100100) Then
         ErrorFlag = 3
      ElseIf ((FromYear + 0) < (MinimumYear + 0)) Or ((ToYear + 0) < (MinimumYear + 0)) Then
         ErrorFlag = 3
      End If
      'Display Error, if any:
      If ErrorFlag = 2 Then
         atemp = MsgBox("A year must be entered in the 'From' box.", 48, "No Year Entered")
      ElseIf ErrorFlag = 3 Then
         atemp = MsgBox("The year boxes may contain only numeric values" & Chr$(13) & "from " & MinimumYear & " to 100100.", 48, "Invalid Year")
      End If
      If ErrorFlag <> 0 Then Exit Sub
   End If
   
   'Display all the holidays for each year specified
   If optDisplayAllByYear = True Then
     atemp = InterFunction_Counter("Set Equal To", 0)
     If FromYear <= ToYear Then One = 1 Else One = -1
     For i = FromYear To ToYear Step One
       Display_All_Holidays_For_Selected_Year i, "Display_Holiday(Calling_Sub)"
     Next
     lblNew.Caption = InterFunction_Counter("Add", 0)
   End If
End Sub
Sub Display_All_Holidays_For_Selected_Year(Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("New Years Day", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Martin Luther King Day", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Valentine's Day", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Presidents' Day", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Mardi Gras", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Ash Wednesday", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("St. Patricks' Day", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Palm Sunday", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Good Friday", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Easter", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Mother's Day", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Ascension Day", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("The Day of Pentecost", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Memorial Day", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Father's Day", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Fourth of July", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Labor Day", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Columbus Day", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Halloween", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Election Day, U.S.", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Veterans Day", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Thanksgiving", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Christmas Eve", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("Christmas Day", Year_, Year_, Calling_Sub_Origin)
   Call Display_Holiday_II("New Years Eve", Year_, Year_, Calling_Sub_Origin)
End Sub
Sub Display_Holiday_II(HolidaySelection, FromYear, ToYear, Calling_Sub_Origin)
   'Get input:
   The_User_Is_Making_Holiday_Selections = False: The_Calendar_Changed = False
   Select Case Calling_Sub_Origin
    Case "Display_Holiday(Calling_Sub)"
      The_User_Is_Making_Holiday_Selections = True
    Case "Form1.Display_Next_Month_On_Calendar()"
      The_Calendar_Changed = True
   End Select

   If The_User_Is_Making_Holiday_Selections Then
      If optByHoliday.Value = True Then
         If (chkSelectRangeOfYears.Value = 0) Then
            ToYear = FromYear
         Else
            If ToYear = "" Then ToYear = FromYear
         End If
      End If
   End If
    
   'Error Checking:
   'Set minimum year that can be selected without an errorflag:
   MinimumYear = 1582
   Select Case HolidaySelection
     Case "Christmas Day", "Christmas Eve", "Halloween", "New Years Eve"
       MinimumYear = 1582
     Case "New Years Day", "Easter", "Ash Wednesday", "Good Friday", "Ascension Day", "The Day of Pentecost", "Mardi Gras", _
     "Palm Sunday", "St. Patricks' Day", "Valentine's Day"
       MinimumYear = 1583
   End Select
   If HolidaySelection = "Fourth of July" Then MinimumYear = 1776
   If HolidaySelection = "Memorial Day" Then MinimumYear = 1868 'el done
   If HolidaySelection = "Labor Day" Then MinimumYear = 1882 'el completo
   If HolidaySelection = "Presidents' Day" Then MinimumYear = 1971 'finished
   If HolidaySelection = "Columbus Day" Then MinimumYear = 1792 'finito
   If HolidaySelection = "Martin Luther King Day" Then MinimumYear = 1983 'finished
   If HolidaySelection = "Election Day, U.S." Then MinimumYear = 1845 'finishedo
   If HolidaySelection = "Veterans Day" Then MinimumYear = 1926 'el testedo
   If HolidaySelection = "Thanksgiving" Then MinimumYear = 1863 'el checked outto
   If HolidaySelection = "Mother's Day" Then MinimumYear = 1907 'debuggedito
   If HolidaySelection = "Father's Day" Then MinimumYear = 1966 'certified and ready for prime time
   'Check for errors:
   ErrorCount = 0: ErrorFlag = 0
   If HolidaySelection = "" Then
      ErrorFlag = 1: ErrorCount = ErrorCount + 1
   End If
   If FromYear = "" Then
      ErrorFlag = 2: ErrorCount = ErrorCount + 1
   ElseIf (FromYear > 100100) Or (ToYear > 100100) Then
      ErrorFlag = 3: ErrorCount = ErrorCount + 1
   ElseIf ((FromYear + 0) < (MinimumYear + 0)) Or ((ToYear + 0) < (MinimumYear + 0)) Then
      ErrorFlag = 3: ErrorCount = ErrorCount + 1
   End If
   If ErrorCount > 1 Then ErrorFlag = 6
     
   'Display error:
   If The_User_Is_Making_Holiday_Selections Then
      If optByHoliday.Value = True Then
       If (ErrorFlag = 1) Then
         atemp = MsgBox("A holiday must be selected.", 48, "No Holiday Selected")
       ElseIf ErrorFlag = 2 Then
         atemp = MsgBox("A year must be entered in the 'From' box.", 48, "No Year Entered")
       ElseIf ErrorFlag = 3 Then
         If HolidaySelection = "Election Day, U.S." Then H_Name = "Election Day" Else H_Name = HolidaySelection
         atemp = MsgBox("For " & H_Name & ", the year boxes may" & Chr$(13) & "contain only numeric values from " & MinimumYear & " to 100100.", 48, "Invalid Year")
       ElseIf ErrorFlag = 6 Then
         atemp = MsgBox("Please specify a holiday and valid year.", 48, "No Selections Made")
       End If
      End If
   End If
   If ErrorFlag <> 0 Then Exit Sub
   atemp = InterFunction_Counter("Add", 1)  'Record all calls to this procedure without errors.
   
   'Display the selected Holiday(s):
   NewResults = 0
   If FromYear <= ToYear Then One = 1 Else One = -1
   For i = FromYear To ToYear Step One
      NewResults = NewResults + 1
      If HolidaySelection = "Easter" Then
         Monthh = Find_Easter(i, "Get Month")
         Ddate = Find_Easter(i, "Get Date")
         MonthNamee = Form1.Define_Month(Monthh, "Get Month Name")
         If The_User_Is_Making_Holiday_Selections Then _
            lstListHolidayDates.AddItem HolidaySelection & ", Sunday, " & MonthNamee & " " & Ddate & ", " & i
      End If
      
      Select Case HolidaySelection
       Case "Ash Wednesday", "Mardi Gras", "Ascension Day", "The Day of Pentecost"
         Monthh = Find_Easter(i, "Get Month")
         Ddate = Find_Easter(i, "Get Date")
         Its_A_Leap_Year = Form1.Is_It_A_Leap_Year(i, "Gregorian")
         If Its_A_Leap_Year Then LeapString = "Get Max Days Leap Year" Else LeapString = "Get Max Days"
         Select Case HolidaySelection
           Case "Mardi Gras"
             CountBack = 47 - Ddate: WeekDayy = "Tuesday": Direction = "Count Backward"
           Case "Ash Wednesday"
             CountBack = 46 - Ddate: WeekDayy = "Wednesday": Direction = "Count Backward"
           Case "Ascension Day"
             MaxDaysCount = Form1.Define_Month(Monthh, LeapString)
             CountAhead = 39 - (MaxDaysCount - (Ddate))
             WeekDayy = "Thursday": Direction = "Count Forward"
           Case "The Day of Pentecost"
             MaxDaysCount = Form1.Define_Month(Monthh, LeapString)
             CountAhead = 49 - (MaxDaysCount - (Ddate))
             WeekDayy = "Sunday": Direction = "Count Forward"
         End Select
         
         CurrentMonth = Monthh
         
         If Direction = "Count Backward" Then
            CurrentMonth = CurrentMonth - 1
            MaxDaysCount = Form1.Define_Month(CurrentMonth, LeapString)
            For j = CountBack To 1 Step -1
               MaxDaysCount = MaxDaysCount - 1
               If MaxDaysCount = 0 Then
                  CurrentMonth = CurrentMonth - 1
                  MaxDaysCount = Form1.Define_Month(CurrentMonth, LeapString)
               End If
            Next j
            Ddate = MaxDaysCount
         End If
         
         If Direction = "Count Forward" Then
            CurrentMonth = CurrentMonth + 1
            MaxDaysCount = Form1.Define_Month(CurrentMonth, LeapString)
            CurrentDate = 0
            For j = 1 To CountAhead
               CurrentDate = CurrentDate + 1
               If CurrentDate = MaxDaysCount + 1 Then
                  CurrentMonth = CurrentMonth + 1
                  CurrentDate = 1
                  MaxDaysCount = Form1.Define_Month(CurrentMonth, LeapString)
               End If
            Next
            Ddate = CurrentDate
         End If
         
         Monthh = CurrentMonth
         MonthNamee = Form1.Define_Month(Monthh, "Get Month Name")
         If The_User_Is_Making_Holiday_Selections Then _
            lstListHolidayDates.AddItem HolidaySelection & ", " & WeekDayy & ", " & MonthNamee & " " & Ddate & ", " & i
      End Select
      
      Select Case HolidaySelection
        Case "Good Friday", "Palm Sunday"
         Monthh = Find_Easter(i, "Get Month")
         Ddate = Find_Easter(i, "Get Date")
         CurrentMonth = Monthh
         If HolidaySelection = "Good Friday" Then
            CountBack = 2: WeekDayy = "Friday"
         ElseIf HolidaySelection = "Palm Sunday" Then
            CountBack = 7: WeekDayy = "Sunday"
         End If
         
         If Ddate <= CountBack Then
            CurrentMonth = CurrentMonth - 1
            Its_A_Leap_Year = Form1.Is_It_A_Leap_Year(i, "Gregorian")
            If Its_A_Leap_Year Then LeapString = "Get Max Days Leap Year" Else LeapString = "Get Max Days"
            MaxDays = Form1.Define_Month(CurrentMonth, LeapString)
            Ddate = Ddate + MaxDays
         End If
         Monthh = CurrentMonth: Ddate = Ddate - CountBack
         MonthNamee = Form1.Define_Month(Monthh, "Get Month Name")
         If The_User_Is_Making_Holiday_Selections Then _
            lstListHolidayDates.AddItem HolidaySelection & ", " & WeekDayy & ", " & MonthNamee & " " & Ddate & ", " & i
      End Select
      
      Select Case HolidaySelection
      Case "Thanksgiving", "Labor Day", "Columbus Day", "Election Day, U.S.", _
      "Presidents' Day", "Martin Luther King Day", "Memorial Day", "Veterans Day", _
      "Christmas Day", "Christmas Eve", "Halloween", "New Years Day", "New Years Eve", _
      "St. Patricks' Day", "Fourth of July", "Valentine's Day", "Mother's Day", "Father's Day"
      
         ReferenceYear = 2000
         If HolidaySelection = "Thanksgiving" Then
            The_Holiday_Is_After_Feb_29 = 1: The_Holiday_Is_Before_Feb_29 = 0
            MonthNamee = "November": WeekDayy = "Thursday": WeekDayNum = 5: MaxDays = 30
            Select Case i
             Case 1942 To 100100 '4th Thursday in November in these years. (but who knows, things can change within the next 100000 years:)
              WeeksToPass = 3: StartingPoint = "Beginning of Month"
             Case 1939 To 1941 '2nd to last Thursday in November in these years.
              WeeksToPass = 1: StartingPoint = "End of Month"
             Case 1863 To 1938 'Last Thursday in November in these years.
              WeeksToPass = 0: StartingPoint = "End of Month"
            End Select
         ElseIf HolidaySelection = "Labor Day" Then
            MonthNamee = "September"
            The_Holiday_Is_After_Feb_29 = 1: The_Holiday_Is_Before_Feb_29 = 0
            Select Case i
             Case 1882 To 1893 '1st Monday in September in the years
               StartingPoint = "Fixed Date": FixedDateOfHoliday = 5
             Case 1894 To 100100 'September 5th in these years
               WeekDayy = "Monday": WeekDayNum = 2: WeeksToPass = 0
               StartingPoint = "Beginning of Month"
             End Select
         ElseIf HolidaySelection = "Columbus Day" Then
           MonthNamee = "October"
           The_Holiday_Is_After_Feb_29 = 1: The_Holiday_Is_Before_Feb_29 = 0
           Select Case i 'October 12th in these years
            Case 1792 To 1970
             StartingPoint = "Fixed Date": FixedDateOfHoliday = 12
            Case 1971 To 100100 '2nd Monday in October in these years
             WeekDayy = "Monday": WeekDayNum = 2: WeeksToPass = 1
             StartingPoint = "Beginning of Month"
           End Select
         ElseIf HolidaySelection = "Election Day, U.S." Then '1st Tuesday after 1st Monday in November (WeekDayNum is set to Monday but the date will be incremented to Tuesday in a later statement.)
            MonthNamee = "November": WeekDayy = "Tuesday": WeekDayNum = 2: WeeksToPass = 0
            The_Holiday_Is_After_Feb_29 = 1: The_Holiday_Is_Before_Feb_29 = 0
            StartingPoint = "Beginning of Month"
         ElseIf HolidaySelection = "Presidents' Day" Then '3rd Monday in February
            MonthNamee = "February": WeekDayy = "Monday": WeekDayNum = 2: WeeksToPass = 2
            The_Holiday_Is_After_Feb_29 = 0: The_Holiday_Is_Before_Feb_29 = 1
            StartingPoint = "Beginning of Month"
         ElseIf HolidaySelection = "Martin Luther King Day" Then '3rd Monday in January
            MonthNamee = "January": WeekDayy = "Monday": WeekDayNum = 2: WeeksToPass = 2
            The_Holiday_Is_After_Feb_29 = 0: The_Holiday_Is_Before_Feb_29 = 1
            StartingPoint = "Beginning of Month"
         ElseIf HolidaySelection = "Memorial Day" Then
            MonthNamee = "May": MaxDays = 31
            The_Holiday_Is_After_Feb_29 = 1: The_Holiday_Is_Before_Feb_29 = 0
            Select Case i
             Case 1971 To 100100 'Last Monday in May for these years
              WeekDayy = "Monday": WeekDayNum = 2: WeeksToPass = 0
              StartingPoint = "End of Month"
             Case 1868 To 1970 'May 30th for these years
              FixedDateOfHoliday = 30: StartingPoint = "Fixed Date"
            End Select
         ElseIf HolidaySelection = "Veterans Day" Then
            The_Holiday_Is_After_Feb_29 = 1: The_Holiday_Is_Before_Feb_29 = 0
            Select Case i
              Case 1968 To 1977 '4th Monday in October for these years
                 MonthNamee = "October": StartingPoint = "Beginning of Month"
                 WeekDayy = "Monday": WeekDayNum = 2: WeeksToPass = 3
              Case 1926 To 1967, 1978 To 100100 'November 11th for all other years (they might change their minds in the year 99265)
                 MonthNamee = "November"
                 FixedDateOfHoliday = 11: StartingPoint = "Fixed Date"
            End Select
         ElseIf HolidaySelection = "Christmas Day" Then
            The_Holiday_Is_After_Feb_29 = 1: The_Holiday_Is_Before_Feb_29 = 0
            MonthNamee = "December"
            StartingPoint = "Fixed Date": FixedDateOfHoliday = 25
         ElseIf HolidaySelection = "Christmas Eve" Then
            The_Holiday_Is_After_Feb_29 = 1: The_Holiday_Is_Before_Feb_29 = 0
            MonthNamee = "December"
            StartingPoint = "Fixed Date": FixedDateOfHoliday = 24
         ElseIf HolidaySelection = "Halloween" Then
            The_Holiday_Is_After_Feb_29 = 1: The_Holiday_Is_Before_Feb_29 = 0
            MonthNamee = "October"
            StartingPoint = "Fixed Date": FixedDateOfHoliday = 31
         ElseIf HolidaySelection = "New Years Day" Then
            The_Holiday_Is_After_Feb_29 = 0: The_Holiday_Is_Before_Feb_29 = 1
            MonthNamee = "January"
            StartingPoint = "Fixed Date": FixedDateOfHoliday = 1
         ElseIf HolidaySelection = "New Years Eve" Then
            The_Holiday_Is_After_Feb_29 = 1: The_Holiday_Is_Before_Feb_29 = 0
            MonthNamee = "December"
            StartingPoint = "Fixed Date": FixedDateOfHoliday = 31
         ElseIf HolidaySelection = "St. Patricks' Day" Then
            The_Holiday_Is_After_Feb_29 = 1: The_Holiday_Is_Before_Feb_29 = 0
            MonthNamee = "March"
            StartingPoint = "Fixed Date": FixedDateOfHoliday = 17
         ElseIf HolidaySelection = "Fourth of July" Then
            The_Holiday_Is_After_Feb_29 = 1: The_Holiday_Is_Before_Feb_29 = 0
            MonthNamee = "July"
            StartingPoint = "Fixed Date": FixedDateOfHoliday = 4
         ElseIf HolidaySelection = "Valentine's Day" Then 'February 14
            The_Holiday_Is_After_Feb_29 = 0: The_Holiday_Is_Before_Feb_29 = 1
            MonthNamee = "February"
            StartingPoint = "Fixed Date": FixedDateOfHoliday = 14
         ElseIf HolidaySelection = "Mother's Day" Then '2nd Sunday in May
            The_Holiday_Is_After_Feb_29 = 1: The_Holiday_Is_Before_Feb_29 = 0
            MonthNamee = "May": StartingPoint = "Beginning of Month"
            WeekDayy = "Sunday": WeekDayNum = 1: WeeksToPass = 1
         ElseIf HolidaySelection = "Father's Day" Then '2nd Sunday in May
            The_Holiday_Is_After_Feb_29 = 1: The_Holiday_Is_Before_Feb_29 = 0
            MonthNamee = "June": StartingPoint = "Beginning of Month"
            WeekDayy = "Sunday": WeekDayNum = 1: WeeksToPass = 2
         End If
         
         MonthBaseDate = Form1.Define_Month(MonthNamee, "Get Base Date Weekday Greg 2000")
         'Above line: MonthBaseDate is actually the weekday number of the month's base date.
         'Determine the difference between the refence base date and the target base date:
         YearDif = ReferenceYear - i 'Determine the number of years from 2000 to TargetYear
         If The_Holiday_Is_After_Feb_29 Then
            NumOfLeapDates = Int((YearDif - 1) / 4) + 1 'Determine the number of leapdates (Feb 29's) in between the reference and target years.
            NumOfCenturies = Int((YearDif - 1) / 100) 'Determine the number of '00 years in between these years
            NumOf400thYears = Int((YearDif - 1) / 400) 'Determine the number of '00 years in between that are divisible by 400
            If i >= 2000 Then
               NumOfCenturies = NumOfCenturies + 1: NumOf400thYears = NumOf400thYears + 1
            End If
         End If
         If The_Holiday_Is_Before_Feb_29 Then
            NumOfLeapDates = Int(YearDif / 4)
            NumOfCenturies = Int(YearDif / 100)
            NumOf400thYears = Int(YearDif / 400)
            If i > 2000 Then
               NumOfCenturies = NumOfCenturies + 1: NumOf400thYears = NumOf400thYears + 1
            End If
         End If
         AdjustedYearDif = YearDif + NumOfLeapDates - NumOfCenturies + NumOf400thYears 'Tested
         
         'Determine the base date for the target month:
         AdjustedYearDif = AdjustedYearDif Mod 7
         TargetBaseDateWeekDay = MonthBaseDate - AdjustedYearDif
         If TargetBaseDateWeekDay < 1 Then _
            TargetBaseDateWeekDay = TargetBaseDateWeekDay + 7 'Make sure the target basedate is not less than 7
         If TargetBaseDateWeekDay > 7 Then _
            TargetBaseDateWeekDay = TargetBaseDateWeekDay - 7 'Make sure the target basedate is not greater than 7
         'Find the date of the holiday:
         'For all holidays that are always on the same weekday and figured from the beginning of the month:
         If StartingPoint = "Beginning of Month" Then
            'Find out when the 1st Weekday of the month is that the holiday is on:
            Ddate = 0
            If TargetBaseDateWeekDay > WeekDayNum Then TargetBaseDateWeekDay = TargetBaseDateWeekDay - 7
            For j = TargetBaseDateWeekDay To WeekDayNum
               If j = 8 Then j = 1
               Ddate = Ddate + 1
            Next
            Ddate = Ddate + (WeeksToPass * 7) 'Move date to the appropriate number of weeks ahead (according to the holiday)
            If HolidaySelection = "Election Day, U.S." Then Ddate = Ddate + 1 'Move date from Monday to Tuesday.
         End If
         'For all holidays that are always on the same weekday and figured from the end of the month:
         If StartingPoint = "End of Month" Then
            TargetBaseDateWeekDay = TargetBaseDateWeekDay + (MaxDays - 29) 'Adjust date from the last base date of the month to the last day of the month.
            If TargetBaseDateWeekDay > 7 Then _
            TargetBaseDateWeekDay = TargetBaseDateWeekDay - 7 'Recheck to make sure TargetBaseDateWeekDay is not greater than 7.
            Ddate = MaxDays + 1
            If TargetBaseDateWeekDay < WeekDayNum Then TargetBaseDateWeekDay = TargetBaseDateWeekDay + 7
            For j = TargetBaseDateWeekDay To WeekDayNum Step -1
               If j = 0 Then j = 7
               Ddate = Ddate - 1
            Next
            Ddate = Ddate - (WeeksToPass * 7)
         End If
         'For all holidays with a fixed date:
         If StartingPoint = "Fixed Date" Then
            Ddate = 1 'set to 1 and the variable "j" set to 2 because the basedate weekday for the first is already stored in the variable "TargetBaseDateWeekDay".
            For j = 2 To FixedDateOfHoliday
               Ddate = Ddate + 1
               TargetBaseDateWeekDay = TargetBaseDateWeekDay + 1
               If TargetBaseDateWeekDay = 8 Then TargetBaseDateWeekDay = 1
            Next
            WeekDayy = Form1.Define_Weekday(TargetBaseDateWeekDay, "Get Weekday Name")
         End If
         
         If The_User_Is_Making_Holiday_Selections Then
            'Next line: Display Output In the Holiday List
            lstListHolidayDates.AddItem HolidaySelection & ", " & WeekDayy & ", " & MonthNamee & " " & Ddate & ", " & i
         End If
      End Select
      '1 - Display the holidays on the calendar when the calendar is refreshed:
      If The_Calendar_Changed Then 'Test whether the purpose is to display holidays on the calendar.
         For j = 0 To 50
            TempMonth = Form1.Store_Holiday_Data_For_Year("Holiday Month", j, "View", "")
            If TempMonth = "" Then
                Element_Number = j
                Exit For
            End If
         Next
         atemp = Form1.Store_Holiday_Data_For_Year("Holiday Month", Element_Number, "Set Equal To", MonthNamee)
         atemp = Form1.Store_Holiday_Data_For_Year("Holiday Date", Element_Number, "Set Equal To", Ddate)
         atemp = Form1.Store_Holiday_Data_For_Year("Holiday Name", Element_Number, "Set Equal To", HolidaySelection)
      End If
      'End 1:
   Next
   If The_User_Is_Making_Holiday_Selections Then
      cmdSave.Enabled = True
      mnuSaveList.Enabled = True
      cmdClear.Enabled = True
      mnuClearList.Enabled = True
      mnuPrintHolidayList.Enabled = True
      'cmdCalendar.Enabled = True
      lblNew.Caption = NewResults 'Display total new results shown in the results window (lstListHolidayDates)
      lblTotalResultsListed.Caption = lstListHolidayDates.ListCount
   End If
End Sub
Function Selected_Holiday_Sent_To_Calendar(Part_Of_String, Contents_Of_String)
   Static Monthh
   Static Ddate
   Static Yearr
   If Part_Of_String = "Write Month" Then
      Monthh = Contents_Of_String: ReturnValue = 0
   ElseIf Part_Of_String = "Write Date" Then
      Ddate = Contents_Of_String: ReturnValue = 0
   ElseIf Part_Of_String = "Write Year" Then
      Yearr = Contents_Of_String: ReturnValue = 0
   End If
   If Part_Of_String = "Get Month" Then ReturnValue = Monthh
   If Part_Of_String = "Get Date" Then ReturnValue = Ddate
   If Part_Of_String = "Get Year" Then ReturnValue = Yearr
   Selected_Holiday_Sent_To_Calendar = ReturnValue
End Function

Private Sub lstListHolidayDates_Click()
   cmdCalendar.Enabled = True
   mnuDisplaySelectedOnCalendar.Enabled = True
   cmdRemoveItem.Enabled = True
   mnuRemoveSelected.Enabled = True
End Sub

Private Sub optByHoliday_Click()
   optDisplayAllByYear.Value = False
   cboHoliday.Enabled = True
End Sub

Private Sub optDisplayAllByYear_Click()
   optByHoliday.Value = False
   cboHoliday.Enabled = False
End Sub
